/*-----------------------------------------------------------------------------
 * sw.h
 * EV2400 firmware
 * 
 * Jennie Kam
 * Version 0.5
 * Last updated: 05/27/09
 * 
 * Contains Timer A interrupt handlers and variables that are common to all 
 * single wire interfaces.  All single wire setup (H2C, C2H) functions
 * can be found in H2Csetup.c/.h
 * 
 * This header file is to be included in all single wire source files
 * and therefore contains constants used across multiple protocols
 * 
 * ---------------------------------------------------------------------------*/

#ifndef SW_H_
#define SW_H_


enum
{
  imWrite = 2,
  imWriteE = 4,
  imRead = 6,
  imReadE = 8,
  imDelay = 10,
  imSDQwrite = 12,
  imSDQpulse = 14,
  imSDQpulseE = 16,
  imSDQprogram = 18
};

/*----------------------------------------------------------------------------+
| Timer A ISR variables
+----------------------------------------------------------------------------*/
extern unsigned char ISRMode;
extern unsigned short Xfer;
extern unsigned char BitCnt;
extern unsigned int Ticks;
extern unsigned char delay_done, write_done, read_done, sw_done, pulse_done;
extern unsigned char timeout_flag;

/*----------------------------------------------------------------------------+
| HDQ constants
+----------------------------------------------------------------------------*/
#define tBreak      191//171 //(190 * ClkFreq / 1110000)   // HDQ Break Time (190us)
#define tBR         40//36  //(40 * ClkFreq / 1110000)    // HDQ Break Recovery Time (40us)
#define tHW1        40//36  //(40 * ClkFreq / 1110000)    // Host sends 1 time 40 for now(21us is avg but causes problems)
#define tHW0        123//111 //(123 * ClkFreq / 1110000)   // Host sends 0 time (123us)
#define tCYCH       230//207 //(230 * ClkFreq / 1110000)   // Host bit window timing (230us)
#define tDW1        41//37  //(41 * ClkFreq / 1110000)    // Slave sends 1 time (41us)
#define tDW0        113//102 //(113 * ClkFreq / 1110000)   // Slave sends 0 time (113us)
#define tTO         500//450 //(500 * ClkFreq / 1110000)   // Time-Out Bit Receiption (500us)

/*----------------------------------------------------------------------------+
| DQ constants
+----------------------------------------------------------------------------*/
#define tBreak_DQ   3900//3700  // DQ Break Time (3.9ms)
#define tBR_DQ      1200//1200  // DQ Break Recovery Time (1.2ms)
#define tHW1_DQ     400//360   // Host sends 1 time .4ms
#define tHW0_DQ     1800//1620  // Host sends 0 time (1.8ms)
#define tCYCH_DQ    3000//2700  // Host bit window timing (3ms)
#define tDW1_DQ     400//360   // Slave sends 1 time (.4ms)
#define tDW0_DQ     1800//1620  // Slave sends 0 time (1.8ms)
#define tTO_DQ      6500//5850  // Time-Out Bit Receiption (6.5ms)

/*----------------------------------------------------------------------------+
| SDQ constants
+----------------------------------------------------------------------------*/
#define tSDQPres 20           // 20 microseconds

/*----------------------------------------------------------------------------+
| USB and setup variables
+----------------------------------------------------------------------------*/
//extern packet *w_rxptr, *r_rxptr, *w_txptr, *r_txptr;
//extern unsigned char Wcompleted, Rresponse, SW_PORT;

//extern unsigned char crc8MakeBitwise(unsigned char CRC, unsigned char Poly, unsigned char *Pmsg, unsigned int Msg_Size);

#endif /*SW_H_*/
